/* defines firm ownership, legal status, age and 
unionisation characteristics over 3 waves 
and creates combined ownership file for all firms, using
characteristics of firms when they first appear in sample */

libname tz 'd:\tanzrped\sasdata';
libname cd 'd:\tanzrped\createdata';
libname cd4 'd:\tanz4\createdata';

data owner1; set tz.tz1new;

firm=key;
wave=1;

union=v2611;
union92=union;
pcunion=v2612;
pcuni92=pcunion;

owner1=v0303;
legal1=v0302;
ethnic1=v0305;

if v0303=7 then state=1; else state=0;
if v0303=4 or v0303=5 or v0303=6 then sstate=1; else sstate=0;
if v0303=2 or v0303=3 then sfor=1; else sfor=0;
if v0303=1 then tzown=1; else tzown=0;
if v0303=2 or v0303=3 or v0303=5 or v0303=6 then anyfor=1;else anyfor=0;
if v0303=4 or v0303=5 or v0303=6 or v0303=7 then anyst=1;else anyst=0;
if v0303=4 or v0303=7 then stattz=1;else stattz=0;

if v0303=1 then privdom=1;else privdom=0;
if v0303=2 then privfor=1;else privfor=0;
if v0303=3 then privdf=1; else privdf=0;
if v0303=4 then sprivdom=1; else sprivdom=0;
if v0303=5 then sprivfor=1; else sprivfor=0;
if v0303=6 then sprivdf=1;else sprivdf=0;
if v0303=7 then state=1;else state=0;

pcfor=v0304;
pcfor92=pcfor;

if v0302=1 then solo=1; else solo=0;
if v0302=2 then partner=1; else partner=0;
if v0302=3 then lle=1; else lle=0;
if v0302=4 and state=0 then privcorp=1; else privcorp=0;
if v0302=4 and state=1 then statcorp=1; else statcorp=0;
if v0302=5 then coop=1; else coop=0;
if v0302=6 then subdom=1; else subdom=0;
if v0302=7 then subfor=1; else subfor=0;

if v0305=1 then african=1; else african=0;
if v0305=2 then european=1; else european=0;
if v0305=3 then asian=1; else asian=0;
if v0305=4 then mideast=1; else mideast=0;
if v0305=5 then other=1; else other=0;

startyr=v0301;
firmage=1993-startyr;

styear1=startyr;

anyfor92=anyfor;
anyst92=anyst;
state92=state;

keep firm wave union union92 pcunion pcuni92
owner1 legal1 ethnic1 styear1
startyr firmage solo partner lle
privcorp statcorp coop subdom subfor
sstate sfor tzown anyfor anyst
pcfor92 anyfor92 anyst92 state92
privdom privfor privdf sprivdom sprivfor sprivdf state
pcfor african european asian mideast other;

proc means; run;
proc sort; by firm wave;


data owner2; set tz.tz2new;

firm=v0no;
wave=2;

change=v0201a;

union=v2309;
union93=union;
pcunion=v2310;
pcuni93=pcunion;

/* ownership variables missing for new firms in wave 2,
data not entered; these are details of new firms in wave2
which were not interviewed in wave 3 */

if firm=103 then legal2=3;
if firm=103 then owner2=1;
if firm=103 then ethnic2=1;
if firm=103 then startyr=1988;
if firm=103 then pcfor=0;

if firm=113 then legal2=1;
if firm=113 then owner2=1;
if firm=113 then ethnic2=1;
if firm=113 then startyr=1987;
if firm=113 then pcfor=0;

if firm=114 then legal2=1;
if firm=114 then owner2=1;
if firm=114 then ethnic2=1;
if firm=114 then startyr=1994;
if firm=114 then pcfor=0;

if firm=118 then legal2=2;
if firm=118 then owner2=1;
if firm=118 then ethnic2=1;
if firm=118 then startyr=1992;
if firm=118 then pcfor=0;

if firm=119 then legal2=2;
if firm=119 then owner2=1;
if firm=119 then ethnic2=1;
if firm=119 then startyr=1991;
if firm=119 then pcfor=0;

if firm=123 then legal2=1;
if firm=123 then owner2=1;
if firm=123 then ethnic2=1;
if firm=123 then startyr=1993;
if firm=123 then pcfor=0;

if firm=236 then legal2=6;
if firm=236 then owner2=1;
if firm=236 then ethnic2=1;
if firm=236 then startyr=1993;
if firm=236 then pcfor=0;

if firm=431 then legal2=1;
if firm=431 then owner2=1;
if firm=431 then ethnic2=1;
if firm=431 then startyr=1992;
if firm=431 then pcfor=0;

if firm=432 then legal2=6;
if firm=432 then owner2=1;
if firm=432 then ethnic2=1;
if firm=432 then startyr=1992;
if firm=432 then pcfor=0;

if firm=533 then legal2=6;
if firm=533 then owner2=1;
if firm=533 then ethnic2=1;
if firm=533 then startyr=1990;
if firm=533 then pcfor=0;

if firm=534 then legal2=1;
if firm=534 then owner2=1;
if firm=534 then ethnic2=1;
if firm=534 then startyr=1984;
if firm=534 then pcfor=0;

if owner2=7 then state=1; else state=0;
if owner2=4 or owner2=5 or owner2=6 then sstate=1; else sstate=0;
if owner2=2 or owner2=3 then sfor=1; else sfor=0;
if owner2=1 then tzown=1; else tzown=0;
if owner2=2 or owner2=3 or owner2=5 or owner2=6 then anyfor=1;else anyfor=0;
if owner2=4 or owner2=5 or owner2=6 or owner2=7 then anyst=1;else anyst=0;

if owner2=4 or owner2=7 then stattz=1;else stattz=0;

if owner2=1 then privdom=1;else privdom=0;
if owner2=2 then privfor=1;else privfor=0;
if owner2=3 then privdf=1; else privdf=0;
if owner2=4 then sprivdom=1; else sprivdom=0;
if owner2=5 then sprivfor=1; else sprivfor=0;
if owner2=6 then sprivdf=1;else sprivdf=0;
if owner2=7 then state=1;else state=0;


if legal2=1 then solo=1; else solo=0;
if legal2=2 then partner=1; else partner=0;
if legal2=3 then lle=1; else lle=0;
if legal2=4 and state=0 then privcorp=1; else privcorp=0;
if legal2=4 and state=1 then statcorp=1; else statcorp=0;
if legal2=5 then coop=1; else coop=0;
if legal2=6 then subdom=1; else subdom=0;
if legal2=7 then subfor=1; else subfor=0;

if ethnic2=1 then african=1; else african=0;
if ethnic2=2 then european=1; else european=0;
if ethnic2=3 then asian=1; else asian=0;
if ethnic2=4 then mideast=1; else mideast=0;
if ethnic2=5 then other=1; else other=0;


firmage=1994-startyr;
styear2=startyr;

pcfor93=pcfor;
anyfor93=anyfor;
anyst93=anyst;
state93=state;

keep firm wave change union union93 pcunion pcuni93
subdom subfor startyr styear2 firmage solo partner lle
privcorp statcorp coop subdom subfor
owner2 legal2 ethnic2
sstate sfor tzown anyfor anyst anyfor93 anyst93 state93
privdom privfor privdf sprivdom sprivfor sprivdf state
pcfor pcfor93 african european asian mideast other;

proc means; run;
proc sort; by firm wave;


data owner3; set tz.tz3new;

options nolabel;

firm=key;
wave=3;

union=v2817;
union95=union;
pcunion=v2818;
pcuni95=pcunion;


if v0203a=1 then tanz=1; else tanz=0;
if v0203b=1 then pfor=1; else pfor=0;
if v0203c=1 then tzgov=1; else tzgov=0;
if v0203d=1 then fgov=1; else fgov=0;

if tanz=1 and pfor=0 and tzgov=0 then privdom=1; else privdom=0;
if tanz=0 and pfor=1 and tzgov=0 then privfor=1; else privfor=0;
if tanz=1 and pfor=1 and tzgov=0 then privdf=1; else privdf=0;
if tanz=1 and pfor=0 and tzgov=1 then sprivdom=1; else sprivdom=0;
if tanz=0 and pfor=1 and tzgov=1 then sprivfor=1; else sprivfor=0;
if tanz=1 and pfor=1 and tzgov=1 then sprivdf=1; else sprivdf=0;
if tanz=0 and pfor=0 and tzgov=1 then state=1; else state=0;

if sprivdom=1 or sprivfor=1 then sstate=1; else sstate=0;
if privfor=1 or privdf=1 then sfor=1; else sfor=0;
if privdom=1 then tzown=1; else tzown=0;
if privfor=1 or privdf=1 or sprivfor=1 then anyfor=1; else anyfor=0;
if sstate=1 or state=1 then anyst=1; else anyst=0;
if sprivdom=1 or state=1 then stattz=1; else stattz=0;


if v0201=1 then solo=1; else solo=0;
if v0201=2 then partner=1; else partner=0;
if v0201=4 then lle=1; else lle=0;
if v0201=5 and state=0 then privcorp=1; else privcorp=0;
if v0201=5 and state=1 then statcorp=1; else statcorp=0;
if v0201=3 then coop=1; else coop=0;

if v0202a=1 then subdom=1; else subdom=0;


if v0204=1 then african=1; else african=0;
if v0204=2 then asian=1; else asian=0;
if v0204=3 then mixed=1; else mixed=0;

anyfor95=anyfor;
anyst95=anyst;
state95=state;

keep firm wave union union95 pcunion pcuni95
 solo partner lle owner3
privcorp statcorp coop subdom
sstate sfor tzown anyfor anyst anyfor95 anyst95 state95
privdom privfor privdf sprivdom sprivfor sprivdf state
african asian mixed;

proc means; run;
proc sort; by firm wave;


/* combined ownership file using wave 1 characteristics
and later waves for new firms only */

data temp1; set owner1;
firm1=firm;
keep firm firm1;

data temp2; set owner2;
firm2=firm;
keep firm firm2;

data temp3; merge temp1 temp2; by firm;
if firm1 ne . then delete;
keep firm;

data owner2; merge temp3 (in=a) owner2; by firm; if a;
proc sort; by firm;

data owner3; merge temp3 (in=a) owner3; by firm; if a;
proc sort; by firm;


data cd.owners; merge owner1 owner2 owner3; by firm;

union=union92;
if union92=. then union=union93;
if union=. then union=union95;
if union=2 then union=0;

/* corrections based on checks */
if firm=32 then state=1;
if firm=32 then anyst=1;
if firm=32 then anyfor=0;
if firm=9 then anyfor=1;
if firm=36 then anyfor=1;
if firm=74 then anyfor=1;
if firm=101 then anyfor=1;
if firm=310 then anyfor=1;
if firm=526 then anyfor=1;

proc means; run;


/*
proc print; var firm african asian mixed other; run;
proc print; var firm state92 state95 anyfor92 anyfor95
anyst92 anyst95; run;
proc print; var firm tzown state anyfor union union92 union93; run;
proc print; var firm wave union owner1 privdom privfor state ; run;
*/